﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.ComponentModel;
using AZVIC.Ei8htPOS.Utilities;
using System.Data;

namespace AZVIC.Ei8htPOS.Entities
{
    public class ProductSubCategory : BusinessBaseClass
    {

        public ProductSubCategory()
        {

        }

        public ProductSubCategory(IDataReader myDataRecord)
        {
            UniqueID = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("ProductSubCategoryID")) ? Guid.Empty : myDataRecord.GetGuid(myDataRecord.GetOrdinal("ProductSubCategoryID"));
            ProductCategoryID = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("ProductCategoryID")) ? Guid.Empty : myDataRecord.GetGuid(myDataRecord.GetOrdinal("ProductCategoryID"));
            SubCategoryName = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("SubCategoryName")) ? string.Empty : myDataRecord.GetString(myDataRecord.GetOrdinal("SubCategoryName"));
            SequenceNo = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("SequenceNo")) ? 0 : myDataRecord.GetInt32(myDataRecord.GetOrdinal("SequenceNo"));
            UserAccountID = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("CreatedBy")) ? Guid.Empty : myDataRecord.GetGuid(myDataRecord.GetOrdinal("CreatedBy"));
            CreatedDate = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("CreatedDate")) ? DateTime.MinValue : myDataRecord.GetDateTime(myDataRecord.GetOrdinal("CreatedDate"));
            ModifiedDate = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("ModifiedDate")) ? DateTime.MinValue : myDataRecord.GetDateTime(myDataRecord.GetOrdinal("ModifiedDate"));
            IsActive = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("IsActive")) ? false : myDataRecord.GetBoolean(myDataRecord.GetOrdinal("IsActive"));
            //IsDeleted = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("IsDeleted")) ? false : myDataRecord.GetBoolean(myDataRecord.GetOrdinal("IsDeleted"));
        }

        [DataObjectField(true, false, false)]
        public override Guid UniqueID { get; set; }

        public Guid ProductCategoryID { get; set; }

        public string SubCategoryName { get; set; }

        public int SequenceNo { get; set; }

        public Guid UserAccountID { get; set; }

        public override DateTime CreatedDate { get; set; }

        public override DateTime ModifiedDate { get; set; }

        public override GlobalConfigurations.Mode Mode { get; set; }

        public override bool IsActive { get; set; }
    }
}
